// imageDir MUST have a trailing slash so we can simply append the image url
var imageDir = "custom/images/";
// imageExtension MUST have a leading dot
var imageExtension = ".gif";
var imgWidth = 18;
var initialStates = 'FitToWin=Disabled&PrevImg=Disabled&MainImg=Disabled&NextImg=Disabled'+
	'&Rotate3d=Disabled&MoveHand=Disabled&FitToWidthPart=Disabled&HideOnePart=Disabled&ShowAllParts=Disabled&SemiTransparent=Disabled'

var standardBtns = 'Print,MoveHand,Rotate3d,ZoomIn,ZoomOut,FitToWin,FitToWidth,FitToWidthPart,Lens,FreeScale,HideOnePart,ShowAllParts,SemiTransparent,PrevImg,MainImg,NextImg,ImageList';

function messageHandler(message, params) {
  if(message == "SetButtonStates") {
    parseString4SetButtonStates(params);
  } else if(message == "SetChoiceList") {
    setChoiceList(params);
  } else if(message == "SetSelectedChoiceItem") {
    setSelectedChoiceItem(params);
  } else if(message == "PrintMode") {
    printMode();
  } else if(message == "HidePrintMode") {
    hidePrintModes() ;
  }
}

function getProperty(property, params) {
  return null;
}
/*
function setIt(params) {
  params = params.split("&");
  var key = new Array();
  var state = new Array();
//  params.sort();
  for(p in params) {
   if(params[p].indexOf("Name") > -1) key[key.length] = params[p];
  }
  for(p in params) {
    if(params[p].indexOf("State") > -1) state[state.length] = params[p];
  }
  var keyValuePairs = new Array();
  
  for(k in key) {
    for(s in state) {
      if(key[k].substring(4,5) == state[s].substring(5,6)) {
        var value = "";
        if(state[s].split("=")[1] == "Enabled") value = "";
        else value = state[s].split("=")[1];
        
        keyValuePairs[keyValuePairs.length] = key[k].split("=")[1] + "=" + value;
      }
    }
  }
//  alert(params+"\n----------------\n"+keyValuePairs.join("&"));
  setButtonsStates(keyValuePairs.join("&"));
}
*/

function parseString4SetButtonStates(incoming) {
  var keyValuePairs = new Array();
  var hash = new Array();
  var counts = 0;
  if(incoming.length > 5) {
    incoming = incoming.split("&");
    for(x in incoming) hash[incoming[x].split("=")[0]] = incoming[x].split("=")[1];
    while(hash['Name'+counts]) {
      var prepared = hash["Name"+counts]+"=";
      prepared+=(hash['State'+counts] == "Enabled") ? "" : hash['State'+counts];
      keyValuePairs[keyValuePairs.length] = prepared;
      counts++;
    }
  }
  setButtonsStates(keyValuePairs.join("&"));
}

function setChoiceList(params) {
  var paramArr = belenusHome.queryStringToArray(params);
  if(paramArr['Name']) {
    var sel = document.getElementById(paramArr['Name']);
    if(sel) { // check if dropdown box exists
      while(sel.options.length > 0) sel.options[sel.options.length-1] = null; // delete all items
      var opts = 0;
      while(paramArr['Label'+opts]) {
        sel.options[sel.length] = new Option(paramArr['Label'+opts++],null,null,null);
      }
      if(opts==0) {
        document.getElementById(paramArr['Name']).disabled = true;
        sel.options[sel.length] = new Option(belenusHome.ld['toolbarOptionLabel'],null,null,null);
        setButtonsStates("MainImg=Disabled&PrevImg=Disabled&NextImg=Disabled");      
      } else if(opts != 1) {
        document.getElementById(paramArr['Name']).disabled = false;
        setButtonsStates("MainImg=&PrevImg=&NextImg=");
      } else { 
        document.getElementById(paramArr['Name']).disabled = true;
        setButtonsStates("MainImg=Disabled&PrevImg=Disabled&NextImg=Disabled");
      }
      if(paramArr['CurrentlySelected']) selectImage(paramArr['Name'], paramArr['CurrentlySelected']);
    }
  }
}

function setSelectedChoiceItem(params) {
  var paramArr = belenusHome.queryStringToArray(params);
  if(paramArr['Name']) { //CurrentlySelected
    var sel = document.getElementById(paramArr['Name']);
    if(sel) { // check if dropdown box exists
      if(paramArr['CurrentlySelected']) selectImage(paramArr['Name'], paramArr['CurrentlySelected']);
    }
  }
}

function selectImage(id,label) {
  var sel = document.getElementById(id);
  if (sel == null) return;
  var i = getIndex(sel, label);
  if (i != -1) sel.selectedIndex = i;
}

function getIndex(sel, text) {
  var index = -1;
  var i;
  for (i = 0; i < sel.length; i++) {
    if (sel.options[i].text == text) {
      index = i;
      break;
    }
  }
  return index;
}

/**
  * called, when user selects another entry in toolbar coice box
 **/
  
function changeImage(id,index) {
  var sel = document.getElementById(id);
  //parent.toolbarChangeImage(sel.options[index].text);
  if(sel) belenusHome.eventHandler("ChoiceChanged","Name="+id+"&Choice="+sel.options[index].text);
}

function doResetBtns() {
  var imgs = document.getElementsByTagName("img");
  for(var i = 0; i < imgs.length; i++) {
    if(imgs[i].getAttribute("width") == "0") {
      imgs[i].style.marginRight = "0px";
    }
  }		
}

function setButtonsStates(qsvalues) {
//alert(qsvalues);
  if (qsvalues.charAt(0) == '?') qsvalues = qsvalues.substring(1);
  var qtemp = new Array();
  qtemp = qsvalues.split("&");
  var hash;
  for (i=0; i<qtemp.length; i++) {
    hash = qtemp[i].split("=");
    if (hash[0] != null && hash[0] != '')
    setButtonState(hash[0], hash[1]);
  }
}

function initializeStates() {
  var imgs = document.getElementsByTagName("img");
  var i;
  for (i = 0; i < imgs.length; i++)
    imgs[i].setAttribute("state", "");
  setButtonsStates(initialStates);
}

function setButtonState(id, state) {
  if (id == "FitToWin") { // remember, if image is in fittowin mode printing full image or cutout
    if (state == "") belenusHome.printCutout= true;
    else if (state == "Disabled") belenusHome.printCutout = false;
  }
  var btn = document.getElementById(id);
//  alert("id: "+id+"\nstate: "+state+"\n\nbtn"+btn);
  if (btn == null) return;
  var append = "";
  if (state == "Pressed") append = "On";
  else if (state == "Disabled" || state == "Invisible") append = "dis";
  btn.src = (imageDir + id + append + imageExtension).toLowerCase();
  btn.setAttribute("state", state);
}

function mouseDown(elem) {
  var id = elem.id;
  var dis = (imageDir + id + "dis" + imageExtension).toLowerCase(); 
  if (elem.getAttribute("state") == null) elem.setAttribute("state", "");
  if (elem.getAttribute("state") != "Disabled" && elem.getAttribute("state") != "Invisible") {
    elem.src = (imageDir + id + "dn" + imageExtension).toLowerCase();
  }
}

function mouseUp(elem) {
  var id = elem.id;
  var append = "";
  if (elem.getAttribute("state") == "Pressed") append = "On";
  else if (elem.getAttribute("state") == "Disabled" || elem.getAttribute("state") == "Invisible") append = "dis";
  elem.src = (imageDir + id + append + imageExtension).toLowerCase();
}


function btn_clicked(elem) {
  if(elem.getAttribute("state") != "Disabled") {
    belenusHome.eventHandler("ButtonClicked","Name="+elem.id);
  }
}

function setPrintModes(doc) {
  if(belenusHome.printModes.length > 1) {
    for(izy in belenusHome.printModes) {
      var opt = new Option(belenusHome.ld[belenusHome.printModes[izy]],belenusHome.printModes[izy],false,false);
      var idAtt = document.createAttribute("id");
      idAtt.nodeValue = belenusHome.addLKey(belenusHome.printModes[izy],self,"",belenusHome.printModes[izy]);
      opt.setAttributeNode(idAtt);
      doc.getElementById('printModesSelect').options[doc.getElementById('printModesSelect').options.length] = opt;
    }
  doc.getElementById("printModesSelect").options[0].text = belenusHome.ld['choosPrintModus'];
  doc.getElementById("printModesSelect").options[0].id = belenusHome.addLKey('choosPrintModus',self,"",'choosPrintModus');
  }
}

function printMode() {
  if(belenusHome.printModes.length == 1) belenusHome.eventHandler("ButtonClicked","Name="+belenusHome.printModes[0]);
  else if(belenusHome.printModes.length > 0){
    var showAllImagesOpts = (belenusHome.getProperty("Global","ImageCount",null) != "1") ? true : false;
    var showSelectedEntriesOpts = (belenusHome.getProperty("Global","SelectedParts").indexOf("ItemPath0") != -1) ? true : false;
    var wo = document.getElementById("printModesSelect").options.length;
    for(var i = wo; i >= 1; i--) document.getElementById("printModesSelect").options[i] = null;
    setPrintModes(self.document);
    
    var countdownOpts = document.getElementById("printModesSelect").options.length-1;
    for(var i = countdownOpts; i >= 1;  i--) {
      if(showAllImagesOpts == false && document.getElementById("printModesSelect").options[i].value.indexOf("AllImages") != -1) {
        document.getElementById("printModesSelect").options[i] = null;
      }
    }

    countdownOpts = document.getElementById("printModesSelect").options.length-1;
    for(var i = countdownOpts; i >= 1;  i--) {
      if(showSelectedEntriesOpts == false && document.getElementById("printModesSelect").options[i].value.indexOf("Sel") != -1) {
        document.getElementById("printModesSelect").options[i] = null;
      }
    }
    setTimeout("document.getElementById('toolbarTable').style.display = 'none';",100);
    setTimeout("document.getElementById('printModes').style.visibility = 'visible';",200);
    setTimeout("document.getElementById('printModes').style.filter='Alpha(opacity=50, finishopacity=50, style=1)'",250);
    setTimeout("document.getElementById('printModes').style.filter='Alpha(opacity=100, finishopacity=100, style=1)'",350);
  }
}

function hidePrintModes() {
  setTimeout("document.getElementById('printModes').style.filter='Alpha(opacity=75, finishopacity=50, style=1)'",100);
  setTimeout("document.getElementById('printModes').style.filter='Alpha(opacity=50, finishopacity=0, style=1)'",200);
  setTimeout("document.getElementById('printModes').style.visibility='hidden';",250);
  setTimeout("document.getElementById('toolbarTable').style.display = 'block';",350);
  setTimeout("document.getElementById('printModesSelect').selectedIndex = 0;",351);
}